# Tone Guidance for Security Writing

## Tone Rules

- Be collaborative, not combative
- Focus on processes and systems, not individuals
- No FUD tactics - justify with business impact, not fear
- Be confident without being arrogant
- Include positive findings - what worked well
- Frame gaps as improvement opportunities

---

## Voice Guidelines

Style guidance for writing in a clear, professional voice

**Do use:**
- Direct, practical language that gets to the point
- 'such as' (not 'like') for introducing examples
- Teaching orientation - explain 'why' and 'how', not just 'what'
- Business terms alongside technical terms to bridge audiences
- Specific numbers over vague quantities ('3 servers' not 'several servers')
- Active voice for clarity and accountability

**Avoid:**
- FUD tactics - justify with business impact, not fear
- Buzzwords that add no precision (leverage, synergy, robust, holistic, paradigm shift)
- Technical jargon without explanation when writing for non-technical audiences
- Passive voice (causes ambiguity about who did what)
- Phrases that sound like marketing copy ('Here's the thing', 'The cool part?')
- Over-the-top validation or excessive praise
- Sounding superior or condescending to colleagues
- One-sentence paragraphs (except to spotlight key points)

**Tone:**
- Professional but approachable
- Confident without arrogance
- Collaborative, not combative
- Critique processes and systems, not people
- Acknowledge what went well, not just problems

**Examples:**

### Critique processes, not people
- Bad: "The administrator's negligent configuration directly caused this vulnerability"
- Good: "The lack of a configuration review process allowed this misconfiguration to persist"
- _Focus on the process gap, not the individual_

### No FUD tactics
- Bad: "This terrifying vulnerability could result in catastrophic, company-ending losses"
- Good: "This vulnerability could allow unauthorized access to customer records, triggering notification requirements under GDPR"
- _State facts and actual impact without emotional language_

### Include what went well
- Bad: "Your security completely failed to prevent this vulnerability"
- Good: "Network segmentation limited the exposure to the development environment only"
- _Acknowledge effective controls alongside gaps_

### Be collaborative, not combative
- Bad: "IT's failure to implement patching was inexcusable"
- Good: "Patching processes were not applied to this system class; this has been added as a remediation item"
- _Frame as improvement opportunity, not blame_

### Avoid passive voice
- Bad: "The system was accessed and data was retrieved."
- Good: "An attacker accessed the system and retrieved 50GB of data."
- _Clarifies who performed the action_

### Be specific with numbers
- Bad: "We found several critical vulnerabilities."
- Good: "We found 4 critical vulnerabilities affecting the payment processing system."
- _Specific numbers build credibility_



---

## Writing as Critique, Not Criticism


**Source:** /security-assessment-report-as-critique

### Principles

#### No Judgment

Find a vocabulary that does not assume the habit or right or duty of judgment. Critique involves providing a well-rounded assessment of the subject's structure, rather than personalizing the identified issues.

#### Focus on the Situation, Not the Person

Comment on factual findings, on the processes that contribute to security issues, and on the structure of the organization that may need adjustment. Stay away from chastising individuals - an angry reader will ignore the report's key messages.

#### Acknowledge the Positive

Include discussion of positive findings. Seeing what aspects of security you liked helps the organization learn from what is working, so it better understands how to address the processes that aren't. Positive reinforcement is often more effective than negative reinforcement in changing behavior.

### Examples

- Bad: "The IT team failed to implement basic security controls"
- Good: "Several security controls were not in place, creating opportunities for improvement"
- _Focus on situation, not people_

- Bad: "Your security posture is unacceptable"
- Good: "The assessment identified gaps that, when addressed, will strengthen the security posture"
- _Frame as improvement, not judgment_

