# Terminology Guidance for Security Writing

## Audience Awareness

Understand your audience before choosing terminology. The same report may need different versions for different readers, or careful layering of technical and business language within a single document.

### Technical Security Teams

- Expect precise terminology (CVSS, CVE, IOCs)
- Value accuracy over accessibility
- Need actionable technical details

_Use standard security terminology without explanation. Terms like CVSS score, lateral movement, and C2 infrastructure are expected and efficient._

### Executive Leadership

- Limited time, need key takeaways quickly
- Think in terms of business risk, cost, and decisions
- May not understand technical acronyms

_Translate technical findings into business impact. Replace or explain jargon. Focus on what happened, what it means, and what decisions are needed._

### Mixed Audiences

- Reports read by both technical and non-technical stakeholders
- Includes legal counsel, insurance adjusters, regulators
- Different sections may serve different readers

_Define technical terms on first use. Use the executive summary for business language and detailed sections for technical precision. Consider a glossary for longer reports._

## Technical Precision Terms

Industry-standard terms that provide precision and are expected by technical audiences. For mixed audiences, define on first use or include in a glossary.

**When to use:** Reports to security teams, technical appendices, vulnerability details

- **CVSS score**: Industry-standard vulnerability severity rating (0-10 scale) _(Required for vulnerability reports; expected by security teams and compliance frameworks)_
- **CVE identifier**: Unique identifier for publicly known vulnerabilities _(Essential for tracking and remediation; always include when referencing known vulnerabilities)_
- **IOCs (Indicators of Compromise)**: Technical evidence of an attack (IP addresses, file hashes, domains) _(Critical for threat hunting and detection; technical teams need the raw data)_
- **TTPs (Tactics, Techniques, and Procedures)**: The attacker's methods, often mapped to MITRE ATT&CK framework _(Valuable for understanding attacker behavior; reference ATT&CK IDs when applicable)_
- **lateral movement**: Attacker spreading from one compromised system to others _(Precise term for a common attack phase; explain as 'spread to other systems' for executives)_

## Jargon Requiring Context

Security terminology that is meaningful to practitioners but may confuse non-technical readers. Explain or replace depending on your audience.

| Term | For Technical | For Executive |
|------|---------------|---------------|
| attack surface | attack surface | exposed systems and services that could be targeted |
| blast radius | blast radius | scope of potential damage if a system is compromised |
| hardening | system hardening | reducing vulnerabilities through secure configuration |
| defense in depth | defense in depth | multiple layers of security controls |
| zero trust | zero trust architecture | verify every access request regardless of network location |
| compensating control | compensating control | alternative security measure when the primary fix isn't feasible |
| false positive | false positive | incorrectly flagged issue that isn't actually a problem |
| risk acceptance | risk acceptance | deliberate decision not to fix an issue after weighing costs and benefits |

## Buzzwords to Avoid

Overused buzzwords and bizspeak that add no precision and often obscure meaning. Unlike technical jargon (which has specific meaning), these terms are vague by nature. Avoid them regardless of audience.

### "leverage"
- **Problem:** Used as a verb meaning 'use' - adds nothing but corporate-speak
- **Use instead:** use, employ, apply
- Bad: "We need to leverage our security tools"
- Good: "We need to use our security tools effectively"

### "synergy"
- **Problem:** Vague term that sounds impressive but means little
- **Use instead:** collaboration, combined benefit, working together
- Bad: "There's synergy between the security and IT teams"
- Good: "The security and IT teams collaborate effectively"

### "paradigm shift"
- **Problem:** Overused to describe any change
- **Use instead:** significant change, new approach, fundamental shift
- Bad: "Zero trust represents a paradigm shift"
- Good: "Zero trust requires rethinking network security assumptions"

### "best-in-class"
- **Problem:** Meaningless without evidence or comparison
- **Use instead:** effective, proven, industry-leading (with evidence)
- Bad: "We implemented best-in-class security controls"
- Good: "We implemented security controls that meet NIST 800-53 requirements"

### "proactive"
- **Problem:** Often used to make reactive measures sound better
- **Use instead:** preventive, anticipatory, planned
- Bad: "We took a proactive approach to security"
- Good: "We implemented monitoring before the incident occurred"

### "robust"
- **Problem:** Vague - what makes it robust?
- **Use instead:** specific qualities (resilient, redundant, tested)
- Bad: "We have robust security controls"
- Good: "We have redundant controls with automated failover"

### "holistic"
- **Problem:** Often meaningless filler
- **Use instead:** comprehensive, integrated, organization-wide
- Bad: "We took a holistic approach to risk management"
- Good: "We assessed risks across all business units"

### "low-hanging fruit"
- **Problem:** Cliché that sounds dismissive
- **Use instead:** quick wins, immediate improvements, easy fixes
- Bad: "Let's address the low-hanging fruit first"
- Good: "Let's address issues that can be fixed quickly"


