---
name: Security-Writing
description: General security report writing guidelines. USE WHEN writing security assessments, reports, or technical documentation.
---

# Security Writing Guidelines

**Author:** Lenny Zeltser
**License:** CC BY 4.0
**Version:** 1.1.0

General writing principles for security reports, assessments, and technical documentation.

## Quick Reference: Five Elements

- **Information**: Answer what readers want to know, not what you want to tell them
- **Tone**: Professional but approachable
- **Words**: Delete words whose absence doesn't change meaning
- **Structure**: Lead with the most important point in each section
- **Look**: Use consistent formatting throughout

## Available Sub-Files

Read these files as needed based on the task:

| File | Use When | Content |
|------|----------|---------|
| FIVE-ELEMENTS.md | Need core writing principles | Information, Tone, Words, Structure, Look |
| CLARITY-RULES.md | Improving sentence/paragraph clarity | Sentence and paragraph rules with examples |
| TONE-GUIDANCE.md | Setting appropriate tone | Tone rules, voice guidelines, critique guidance |
| EXECUTIVE-SUMMARY.md | Writing executive summaries | Executive summary rules and report qualities |
| TERMINOLOGY.md | Choosing appropriate terminology | Audience-aware terminology, jargon guidance, buzzwords to avoid |

## How to Use

When helping with security writing:

1. First understand the user's task (writing new report, improving clarity, reviewing tone)
2. Read only the sub-files relevant to that specific task
3. Apply guidance from the sub-files you loaded

**Privacy:** Your analysis happens locally. User documents are never sent to any server.

## Source Articles

- https://zeltser.com/security-assessment-report-as-critique
- https://zeltser.com/writing-tips-for-it-professionals
- https://zeltser.com/good-security-assessment-report
- https://zeltser.com/executive-summary-for-security-assessment-report-tips
