# Five Elements of Effective Security Writing

### Information

- Answer what readers want to know, not what you want to tell them
- Include all necessary details: who, what, when, where, why, how
- Balance technical depth with business relevance
- Teaching orientation: explain 'why' and 'how', not just 'what'

### Tone

- Professional but approachable
- Confident without being arrogant
- Helpful without being condescending
- Collaborative, not combative
- Critique processes, not people
- Include what went well, not just what went wrong
- No FUD tactics - use business justification, not fear

### Words

- Delete words whose absence doesn't change meaning
- Avoid passive voice - it leads to ambiguity
- Be specific: use numbers, not 'some' or 'many'
- Adapt terminology to your audience - technical precision for practitioners, plain language for executives
- Avoid buzzwords that obscure meaning regardless of audience (leverage, synergy, robust)
- Keep sentences under 15 words when possible
- Define technical terms on first use for mixed audiences

### Structure

- Lead with the most important point in each section
- Use frameworks, numbered lists, and clear organization
- Include headings for scanability
- Break long paragraphs into shorter ones
- Executive summary must stand alone
- Maintain flow: sentences should connect ideas, paragraphs should develop thoughts
- Avoid choppy, bullet-point-like prose where each sentence stands in isolation
- Avoid one-sentence paragraphs unless spotlighting a key point

### Look

- Use consistent formatting throughout
- Tables for structured data (action items, timelines)
- Err on the side of simplicity
- Well-formatted reports are more likely to be read
