# Executive Summary Guidelines

## Rules for Effective Executive Summaries

- **Must make sense to non-technical executives**

- **Connect findings to business relevance: risks, compliance, costs**

- **Keep to one page maximum**
  - _Note: Most readers only see the executive summary_

- **Use concrete statements with numbers**

- **Must stand alone if distributed separately**

- **Bridge technical and business perspectives**

- **Use concrete statements - they build more trust than abstract language**
  - _Note: Research shows specific language communicates truth more effectively_

- **Use bullet points for scannability**

- **Answer 'so what?' for every fact and conclusion**
  - _Note: Executives think in terms of actions and business impact_

---

## 6 Qualities of a Good Security Assessment Report

### Strong Executive Summary

Opens with a summary that a non-technical reader can understand. Given short attention spans, most readers won't get past this section.

### Meaningful Analysis

Provides analysis beyond tool output. The value is in making sense of and deriving meaning from collected data.

### Supporting Figures

Includes figures to substantiate findings, allowing readers to confirm observations are based on factual data.

### Methodology and Scope Documentation

Describes tools, approaches, and techniques employed, demonstrating a professional and systematic approach.

### Professional Appearance

Looks professional and is without typos. Sloppy documents make it hard for readers to take the content seriously.

### Logical Section Structure

Structured in logical sections to accommodate different reader groups. Some readers only care about certain aspects.

---

## Writing Tips for Longer Reports

- **Create a strong executive summary that stands on its own** - _Most readers won't get past this section_
- **Split the report into multiple sections to logically group content**
- **Strive for simple structure, avoiding deep nesting of headings**
- **Include at least one paragraph between two headings for introduction or transition**
- **Craft captions that guide readers to conclusions about charts or figures**
- **Place lengthy technical excerpts into an appendix**
- **Refer to every figure and appendix section from your main text**

### Formatting Tips

- Err on the side of simplicity when selecting visual style
- Use italics or boldface for emphasis, not both
- Avoid breaking short lists or paragraphs across pages
- Keep font size and typeface consistent throughout
- Crop and size screenshots to ensure readability
