# Clarity Rules for Security Writing

## Sentence Rules

- **Keep sentences under 15 words when possible**
  - _Note: Shorter sentences are easier to parse, especially under stress_

- **Delete words whose absence doesn't change meaning**
  - Bad: "It is important to note that the vulnerability exists"
  - Good: "The vulnerability exists"

- **Avoid passive voice - it leads to ambiguity**
  - Bad: "The configuration was changed"
  - Good: "The administrator changed the configuration"

- **Be specific with numbers**
  - Bad: "Several systems were affected for many hours"
  - Good: "3 systems were affected for 14 hours"

- **Adapt terminology to your audience**
  - _Note: Technical terms are appropriate for technical readers; explain or replace for executives_
  - Bad: "We need to harden the attack surface and reduce blast radius"
  - Good: "We need to reduce the number of exposed services and limit what an attacker can access if they break in"

- **Avoid semicolons and parentheses - break into separate sentences**
  - Bad: "The assessment revealed critical issues; however, immediate remediation was possible (though resource-intensive)."
  - Good: "The assessment revealed critical issues. Immediate remediation was possible but resource-intensive."

---

## Paragraph Rules

- Place your most important point at the beginning
- Split long paragraphs for easier skimming
- Avoid one-sentence paragraphs unless spotlighting a key point
- Maintain flow: sentences should connect ideas, not stand in isolation
- Delete paragraphs that don't contribute to the flow
- Make sure sentences in the paragraph support the paragraph's objective
