# Zeltser Security Report Skills

Local AI skills for writing and reviewing security reports.
Generated from the same source as the [MCP server tools](https://github.com/lennyzeltser/zeltser-website-mcp-server).

**Version:** IR 1.4.0, Writing 1.1.0
**Generated:** 2026-01-16T02:35:19.347Z
**Author:** Lenny Zeltser
**License:** CC BY 4.0

## Installation

### Claude Code

Copy the skill folders to your Claude Code skills directory:

```bash
# macOS/Linux
cp -r IR-GUIDELINES ~/.claude/skills/
cp -r SECURITY-WRITING ~/.claude/skills/

# Windows
xcopy /E IR-GUIDELINES %USERPROFILE%\.claude\skills\IR-GUIDELINES\
xcopy /E SECURITY-WRITING %USERPROFILE%\.claude\skills\SECURITY-WRITING\
```

### Other AI Tools

These skills are Markdown files that can be used with any AI tool that supports custom prompts or context files.

## What's Included

### IR-GUIDELINES

Comprehensive guidance for incident response report writing:

- **SKILL.md** - Entry point with quick reference
- **TEMPLATE.md** - Fill-in-the-blank IR report template
- **FIELD-GUIDANCE.md** - 9 field guides for completeness checking
- **INCIDENT-TYPES.md** - Ransomware, BEC, data breach, insider threat, supply chain
- **WRITING-RULES.md** - Five elements, sentence/paragraph rules, jargon guidance
- **NOTIFICATIONS.md** - GDPR, CCPA, HIPAA, state law guidance
- **REVIEW-CRITERIA.md** - Section-by-section review criteria

### SECURITY-WRITING

General security report writing guidance:

- **SKILL.md** - Entry point with quick reference
- **FIVE-ELEMENTS.md** - Information, Tone, Words, Structure, Look
- **CLARITY-RULES.md** - Sentence and paragraph rules
- **TONE-GUIDANCE.md** - Voice guidelines and critique approach
- **EXECUTIVE-SUMMARY.md** - Executive summary and report quality guidance
- **TERMINOLOGY.md** - Audience-aware terminology choices

## How It Works

Each skill has a main SKILL.md entry point that:
1. Provides a quick reference of core principles
2. Lists sub-files with descriptions of when to read them
3. Instructs the AI to selectively load only what's needed

This modular structure keeps context usage efficient while providing full guidance when needed.

## Updates

Download the latest version from: https://zeltser.com/media/zeltser-security-report-skills.zip

## Related Resources

- [IR Report Template Article](https://zeltser.com/incident-response-report-template)
- [Writing Tips for IT Professionals](https://zeltser.com/writing-tips-for-it-professionals)
- [MCP Server (alternative approach)](https://github.com/lennyzeltser/zeltser-website-mcp-server)

## Privacy

These skills provide guidance that your AI applies locally. Your documents and notes are never sent to any server.
