# Writing Rules for IR Reports

## Five Elements of Effective Writing

### Information

- Answer what readers want to know, not what you want to tell them
- Include all necessary details: who, what, when, where, why, how
- Balance technical depth with business relevance
- Teaching orientation: explain 'why' and 'how', not just 'what'

### Tone

- Professional but approachable
- Confident without being arrogant
- Helpful without being condescending
- Collaborative, not combative
- Critique processes, not people
- Include what went well, not just what went wrong
- No FUD tactics — use business justification, not fear

### Words

- Delete words whose absence doesn't change meaning
- Avoid passive voice — it leads to ambiguity
- Be specific: use numbers, not 'some' or 'many'
- Adapt terminology to your audience — technical precision for practitioners, plain language for executives
- Define technical terms on first use for mixed audiences
- Avoid buzzwords that obscure meaning (leverage, robust, holistic)
- Keep sentences under 15 words when possible

### Structure

- Lead with the most important point in each section
- Use frameworks, numbered lists, and clear organization
- Include headings for scanability
- Break long paragraphs into shorter ones
- Executive summary must stand alone
- Maintain flow: sentences should connect ideas, paragraphs should develop thoughts
- Avoid choppy, bullet-point-like prose where each sentence stands in isolation
- Avoid one-sentence paragraphs unless spotlighting a key point

### Look

- Use consistent formatting throughout
- Tables for structured data (action items, timelines)
- Err on the side of simplicity
- Well-formatted reports are more likely to be read

---

## Sentence Rules

- **Keep sentences under 15 words when possible**
  - _Note: Shorter sentences are easier to parse under stress_

- **Delete words whose absence doesn't change meaning**
  - Bad: "It is important to note that the attacker gained access"
  - Good: "The attacker gained access"

- **Avoid passive voice — it leads to ambiguity**
  - Bad: "The server was compromised"
  - Good: "The attacker compromised the server"

- **Be specific with numbers**
  - Bad: "Several servers were affected for many hours"
  - Good: "3 servers were affected for 14 hours"

- **Adapt terminology to your audience**
  - _Note: Technical terms are appropriate for technical readers; explain or replace for executives_
  - Bad: "The threat actor leveraged a zero-day to pivot laterally"
  - Good: "The attacker used an unpatched vulnerability to access additional servers"

---

## Paragraph Rules

- Place your most important point at the beginning
- Split long paragraphs for easier skimming
- Avoid one-sentence paragraphs unless spotlighting a key point
- Maintain flow: sentences should connect ideas, not stand in isolation
- Delete paragraphs that don't contribute to the flow

---

## Tone Rules

- Be collaborative, not combative
- Focus on processes and systems, not individuals
- No FUD tactics — justify with business impact, not fear
- Be confident without being arrogant
- Include positive findings — what worked well
- Frame lessons as improvement opportunities

---

## Executive Summary Rules

- **Must make sense to non-technical executives**

- **Connect findings to business relevance: risks, compliance, costs**

- **Keep to one paragraph (150 words max)**

- **Use concrete statements with numbers**

- **Must stand alone if distributed separately**

- **Bridge technical and business perspectives**

- **Connect findings to business context**
  - _Note: Reference risks, compliance requirements, metrics, or contractual obligations_

- **Use concrete statements — they build more trust than abstract language**
  - _Note: Research shows specific language communicates truth more effectively_

- **Use bullet points for scannability**

- **Answer 'so what?' for every fact and conclusion**
  - _Note: Executives think in terms of actions and business impact_

---

## Voice Guidelines

Style guidance for writing in a clear, professional voice

**Do use:**
- Direct, practical language that gets to the point
- 'such as' (not 'like') for introducing examples
- Teaching orientation — explain 'why' and 'how', not just 'what'
- Business terms alongside technical terms to bridge audiences
- Specific numbers over vague quantities ('3 servers' not 'several servers')
- Active voice for clarity and accountability

**Avoid:**
- Emojis (unless organizational culture expects them)
- FUD tactics — justify with business impact, not fear
- Jargon that obscures meaning for the intended audience
- Passive voice (causes ambiguity about who did what)
- Phrases that sound like marketing copy ('Here's the thing', 'The cool part?')
- Over-the-top validation or excessive praise
- Sounding superior or condescending to colleagues
- One-sentence paragraphs (except to spotlight key points)

**Tone:**
- Professional but approachable
- Confident without arrogance
- Collaborative, not combative
- Critique processes and systems, not people
- Acknowledge what went well, not just problems

**Examples:**

### Critique processes, not people
- Bad: "The user's negligent password practices directly caused this breach"
- Good: "Password reuse between personal and corporate accounts enabled the initial compromise"
- _Focus on the process gap (password policy), not the individual_

### No FUD tactics
- Bad: "This terrifying breach could have resulted in catastrophic, company-ending losses"
- Good: "The attempted wire fraud of $847,000 was blocked; no financial loss occurred"
- _State facts and actual impact without emotional language_

### Include what went well
- Bad: "Our security completely failed to prevent this attack"
- Good: "EDR detection triggered within 17 minutes of encryption starting, enabling rapid containment"
- _Acknowledge effective controls alongside gaps_

### Be collaborative, not combative
- Bad: "IT's failure to implement geo-blocking was inexcusable"
- Good: "Geographic access restrictions were not configured; this has been added as a remediation item"
- _Frame as improvement opportunity, not blame_



---

## Writing Analysis: Common Issues

## Jargon

**What to check:** Technical terms and acronyms that may confuse non-technical readers

**Why it matters:** IR reports are read by executives, legal counsel, insurance adjusters, and regulators—not just security engineers. Unexplained jargon creates confusion and undermines credibility.

**Examples:**

| Bad | Good |
|-----|------|
| lateral movement | spread to other systems |

_Executive readers may not know this term_

| Bad | Good |
|-----|------|
| C2 or C&C | command-and-control server (the attacker's remote control point) |

| Bad | Good |
|-----|------|
| IOCs | indicators of compromise (evidence of the attack) |

| Bad | Good |
|-----|------|
| TTPs | tactics, techniques, and procedures (the attacker's methods) |

| Bad | Good |
|-----|------|
| exfiltrated | stolen or transferred out of the network |

| Bad | Good |
|-----|------|
| persistence mechanism | method for maintaining access |

| Bad | Good |
|-----|------|
| privilege escalation | gained higher-level access or obtained administrator rights |

| Bad | Good |
|-----|------|
| beaconing | regularly communicating with attacker's server |

| Bad | Good |
|-----|------|
| living off the land | using legitimate system tools for malicious purposes |

| Bad | Good |
|-----|------|
| EDR | endpoint detection and response (security monitoring software) |

| Bad | Good |
|-----|------|
| SIEM | security information and event management (log analysis system) |

| Bad | Good |
|-----|------|
| APT | advanced persistent threat (sophisticated, targeted attacker) |

| Bad | Good |
|-----|------|
| zero-day | previously unknown vulnerability |

| Bad | Good |
|-----|------|
| payload | malicious code or malware component |

| Bad | Good |
|-----|------|
| dropper | program that installs malware |


---

## Passive Voice

**What to check:** Sentences where the actor is unclear or responsibility is obscured

**Why it matters:** Incident reports must clearly attribute actions. Passive voice obscures whether the attacker, defender, or system performed an action, creating ambiguity that can have legal implications.

**Examples:**

| Bad | Good |
|-----|------|
| The server was accessed and files were exfiltrated. | The attacker accessed the server and exfiltrated 50GB of files. |

_Clarifies who performed the action_

| Bad | Good |
|-----|------|
| Credentials were reset. | The IT team reset all administrative credentials within 2 hours. |

_Attributes the response action_

| Bad | Good |
|-----|------|
| The malware was discovered on the system. | EDR detected the malware on WS-001 at 14:32 UTC. |

_Specifies what detected it and when_

| Bad | Good |
|-----|------|
| A decision was made to isolate the network segment. | The CISO directed the SOC to isolate the network segment. |

_Documents decision-making authority_


---

## Vague Terms

**What to check:** Imprecise quantifiers that should be replaced with specific numbers

**Why it matters:** Stakeholders need specifics for decision-making, insurance claims, and regulatory filings. Vague terms undermine the report's usefulness and credibility.

**Examples:**

| Bad | Good |
|-----|------|
| Several servers were affected. | Three servers were affected: FS01, DC02, and WEB03. |

| Bad | Good |
|-----|------|
| The attacker was in the network for some time. | The attacker maintained access for 18 days. |

| Bad | Good |
|-----|------|
| A significant amount of data was exfiltrated. | Approximately 2.3 GB of data (1,247 records) was exfiltrated. |

| Bad | Good |
|-----|------|
| Many users' credentials were compromised. | Credentials for 47 user accounts were compromised. |

| Bad | Good |
|-----|------|
| The incident had a substantial financial impact. | The incident cost approximately $130,000 in response and recovery. |


---

## Sentence Length

**What to check:** Overly long sentences that are difficult to parse

**Why it matters:** Clear communication requires digestible sentences. Long, complex sentences increase the chance of misunderstanding, especially for non-native English readers or those skimming the report.

**Examples:**

| Bad | Good |
|-----|------|
| The attacker, having gained initial access through a phishing email that was sent to an employee in the accounting department who clicked on a malicious link that exploited a vulnerability in the browser, then proceeded to move laterally through the network using stolen credentials until reaching the file server.
 | The attacker gained initial access through a phishing email to an accounting employee. The malicious link exploited a browser vulnerability. Using stolen credentials, the attacker moved laterally until reaching the file server.
 |

_Break complex sequences into separate sentences_


---

## Document Formatting

**What to check:** Document structure and formatting for readability

**Why it matters:** A well-formatted report is more likely to be read and taken seriously. Visual organization signals clear thinking and professionalism.

**AI-checkable items:**
- Consistent heading hierarchy (H1 for title, H2 for sections, H3 for subsections)
- Tables used for structured data (timelines, action items, affected systems)
- Bullet points for lists rather than run-on paragraphs
- Each section can stand alone if excerpted

**User reminders:**
- Sufficient whitespace between sections
- Professional fonts and consistent styling
- Page breaks before major sections in final document
- Tables fit on page without awkward wrapping
- Consistent date and time formats throughout


---


