---
name: IR-Guidelines
description: Incident response report writing guidelines. USE WHEN writing, reviewing, or analyzing IR reports.
---

# IR Report Writing Guidelines

**Author:** Lenny Zeltser
**License:** CC BY 4.0
**Version:** 1.4.0

This skill provides comprehensive guidance for writing incident response reports.

## Quick Reference: Five Elements

- **Information**: Answer what readers want to know, not what you want to tell them
- **Tone**: Professional but approachable
- **Words**: Delete words whose absence doesn't change meaning
- **Structure**: Lead with the most important point in each section
- **Look**: Use consistent formatting throughout

## Available Sub-Files

Read these files as needed based on the task:

| File | Use When | Content |
|------|----------|---------|
| TEMPLATE.md | User needs the report template | Fill-in-the-blank IR report template |
| FIELD-GUIDANCE.md | Checking if report covers all required fields | 9 field guides with examples |
| INCIDENT-TYPES.md | Identifying incident type or type-specific guidance | Ransomware, BEC, data breach, insider, supply chain |
| WRITING-RULES.md | Reviewing writing quality | Sentence, paragraph, tone rules + jargon guidance |
| NOTIFICATIONS.md | Checking regulatory requirements | GDPR, CCPA, HIPAA, state laws |
| REVIEW-CRITERIA.md | Reviewing/critiquing an existing report | Section-by-section review criteria |

## How to Use

When helping with IR reports:

1. First understand the user's task (writing new report, reviewing existing, checking completeness)
2. Read only the sub-files relevant to that specific task
3. Apply guidance from the sub-files you loaded

**Privacy:** Your analysis happens locally. User documents are never sent to any server.

## Related Resources

- [How to Write Good Incident Response Reports](https://zeltser.com/good-incident-reports) - Full methodology and video presentation
- [Writing Tips for IT Professionals](https://zeltser.com/writing-tips-for-it-professionals) - Comprehensive writing cheat sheet
- [Write a Strong Executive Summary](https://zeltser.com/executive-summary-for-security-assessment-report-tips) - Detailed executive summary guidance
- [Security Assessment Report as Critique](https://zeltser.com/security-assessment-report-as-critique) - Tone guidance for sensitive reports
- [Top 10 Cybersecurity Writing Mistakes](https://zeltser.com/cybersecurity-writing-mistakes) - Common pitfalls to avoid
