# IR Report Review Criteria

Use this guidance when reviewing or critiquing an existing IR report.

## Reviewer Mindset

- You are helping improve the report, not judging the author
- Assume good intent — gaps may reflect incomplete information, not carelessness
- The author wrote under time pressure during a stressful incident
- Focus on the document's effectiveness for its intended audience
- Consider what information the author might not have had access to

## Feedback Structure

- Start with what the report does well — identify specific strengths
- Identify areas for improvement with concrete, actionable suggestions
- Reference specific sections and quote text when providing feedback
- Offer alternatives or examples, not just criticisms
- Prioritize feedback by impact on the report's effectiveness
- Distinguish between critical issues and minor improvements

## Feedback Tone

- Use collaborative language ('consider', 'you might', 'this could be strengthened by')
- Avoid judgmental phrases ('you failed to', 'this is wrong', 'obviously')
- Frame gaps as opportunities ('adding X would help readers understand Y')
- Acknowledge constraints ('if this information is available, including it would...')

---

# Section-by-Section Review Criteria

## Executive Summary

**Check for:**
- Understandable to non-technical executives
- Connects to business relevance (risks, compliance, impact)
- Under 150 words
- Uses concrete numbers, not vague terms
- Stands alone without requiring rest of report
- Key takeaways appear in first sentences

**Common issues:**
- Too technical — uses jargon executives won't understand
- Too long — exceeds one page
- Too vague — uses 'some', 'many', 'several' instead of numbers
- Missing business context — only describes technical details


---

## Timeline

**Check for:**
- Clear chronological sequence with specific dates/times
- Includes timezone information
- Distinguishes between when events occurred vs. when discovered
- Uses active voice to clarify who did what

**Common issues:**
- Vague timing ('recently', 'last week')
- Missing timezone
- Passive voice obscures responsibility
- Gaps in timeline not acknowledged


---

## Root Cause

**Check for:**
- Explains 'why' not just 'what'
- Distinguishes root cause from symptoms
- Describes how root cause was determined (evidence)
- Avoids blaming individuals

**Common issues:**
- Describes symptoms as root cause
- Blames individuals rather than processes
- No evidence for root cause determination
- Multiple possible causes without prioritization


---

## Actions Taken

**Check for:**
- Specific actions with who performed them
- Chronological or logical ordering
- Distinguishes containment from remediation from recovery
- Includes both successful and unsuccessful attempts

**Common issues:**
- Vague actions ('addressed the issue')
- Missing attribution (who did what)
- Only lists successful actions
- No distinction between phases of response


---

## Lessons Learned

**Check for:**
- Actionable recommendations with assigned owners
- Each action has an expected completion date or timeframe
- Actions prioritized by urgency (immediate, short-term, long-term)
- Acknowledges what went well, not just gaps
- Focuses on processes and systems, not individuals
- Prioritized by impact

**Common issues:**
- Generic lessons without specific actions
- No ownership assigned
- Missing timelines or target dates
- Only negative findings
- Blames individuals


---

## Business Impact

**Check for:**
- Quantified where possible (systems, users, records, hours, cost)
- Includes both confirmed and potential impact
- Addresses multiple stakeholder concerns
- Uses business terminology

**Common issues:**
- Technical impact only (no business translation)
- Vague quantities
- Missing potential/ongoing impact
- Only worst-case without context


---

## What Went Well

**Check for:**
- Identifies specific controls or processes that worked
- Quantifies effectiveness where possible (detection time, containment speed)
- Acknowledges team actions that limited impact
- Balanced with improvement areas (not defensive)

**Common issues:**
- Omitted entirely — report is only negative findings
- Too vague ('our team responded well')
- Defensive tone rather than objective assessment
- Not connected to lessons learned


---

## Third Party

**Check for:**
- Identifies all affected third parties
- Documents notification status and timeline
- Addresses contractual and regulatory obligations
- Outlines coordination requirements

**Common issues:**
- Third parties not identified until late in investigation
- Notification obligations overlooked
- No documentation of what was shared with third parties
- Missing follow-up requirements


---

## Data Exposure

**Check for:**
- Specific data types identified (not just 'sensitive data')
- Scope quantified (records, individuals)
- Regulatory implications addressed
- Distinguishes confirmed vs. potential exposure

**Common issues:**
- Vague descriptions ('some data may have been accessed')
- Regulatory requirements not identified
- Scope not quantified
- No distinction between accessed vs. exfiltrated



---

# Cross-Cutting Quality Checks

## Business Relevance

Every section should connect technical details to business context

**Check for:**
- Does each section explain why the information matters to stakeholders?
- Are compliance and regulatory implications addressed where relevant?
- Would a non-technical executive understand the significance?
- Is the 'so what?' answered for facts and conclusions?


## Consistency

Information should be consistent throughout the document

**Check for:**
- Are numbers consistent across sections (affected systems count, timeline dates)?
- Do terms and acronyms match throughout the document?
- Are severity characterizations consistent?
- Do timeline references in different sections align?


## Completeness

Each section should be self-contained enough to be excerpted

**Check for:**
- Can each major section stand alone if shared separately?
- Are key findings repeated in the executive summary?
- Are all action items captured in the action items section (not buried in narrative)?


