# Regulatory Notification Guidance

**Important:** Always consult legal counsel for authoritative interpretation of notification requirements.

## GDPR

**Deadline:** 72 hours from becoming aware of breach

**Triggers:**
- Personal data of EU/EEA residents accessed or exfiltrated
- EU employees, customers, or partners affected
- Data processed under EU operations or targeting EU market

**Scope:** Applies to organizations processing personal data of EU residents, regardless of where the organization is located.

**Important caveats:**
- Consult legal counsel for authoritative interpretation
- 72-hour clock starts when breach is confirmed, not suspected
- May require individual notification in addition to authority notification
- Document decision-making process if determining notification not required


---

## CCPA/CPRA

**Deadline:** Expedient notification, no fixed hour deadline

**Triggers:**
- Personal information of California residents accessed
- Unencrypted personal data acquired by unauthorized person
- Categories include name + SSN, driver's license, financial account, medical, biometric

**Scope:** Applies to businesses meeting California thresholds that experience breach of California resident personal information.

**Important caveats:**
- Consult California-licensed counsel for specific requirements
- Definition of "breach" requires acquisition, not just access
- Safe harbor for encrypted data if key not compromised
- May trigger private right of action if security was inadequate


---

## HIPAA

**Deadline:** 60 days from discovery for breaches over 500 individuals

**Triggers:**
- Protected health information (PHI) accessed or disclosed
- Healthcare provider, health plan, or business associate involved
- Unsecured PHI acquired by unauthorized person

**Scope:** Applies to covered entities (healthcare providers, plans) and their business associates handling protected health information.

**Important caveats:**
- Consult healthcare compliance counsel
- Smaller breaches have annual reporting, not immediate
- Risk assessment may determine notification not required
- HHS Office for Civil Rights must be notified for large breaches


---

## State Breach Laws

**Deadline:** Varies by state (24 hours to 90 days)

**Triggers:**
- Personal information of state residents accessed
- Definitions vary by state (some include username/password)
- Multi-state incidents may trigger multiple requirements

**Scope:** All 50 US states plus territories have breach notification laws with varying definitions, timelines, and requirements.

**Important caveats:**
- Consult counsel familiar with multi-state notification
- Some states require AG notification in addition to individuals
- Credit monitoring requirements vary by state
- Document which states' residents are affected


