# Incident Type Guidance

Use this to identify the incident type and apply type-specific reporting considerations.

## Ransomware

Attack where malicious software encrypts files or systems, with attackers demanding payment for decryption keys.

**Indicators:**
- Files or systems encrypted and inaccessible
- Ransom demand received (email, text file, screen message)
- Payment requested in cryptocurrency
- Known ransomware variant mentioned (LockBit, BlackCat, Cl0p)
- Encrypted files have unusual extensions
- Backups or shadow copies deleted

**Reporting considerations:**
- Document ransom amount and payment address demanded
- Note whether data was exfiltrated before encryption (double extortion)
- Record encryption scope (specific systems vs. entire network)
- Preserve any attacker communications for law enforcement
- Document backup availability and recovery options

**Common patterns:**
- Initial access via phishing or exploited VPN/RDP
- Lateral movement using legitimate admin tools
- Credential harvesting before encryption
- Data exfiltration for double extortion leverage
- Encryption during off-hours to maximize impact


---

## Business Email Compromise (BEC)

Social engineering attack using email to manipulate employees into transferring funds or sensitive information.

**Indicators:**
- Fraudulent wire transfer or payment redirection
- Invoice manipulation or fake vendor communications
- Executive impersonation emails
- Compromised email account used to send internal requests
- Urgency and secrecy emphasized in requests

**Reporting considerations:**
- Document the fraudulent transaction details and amounts
- Identify the compromised or spoofed account
- Trace the communication chain that led to the fraud
- Note what validation steps were bypassed
- Record fund recovery efforts and bank notifications

**Common patterns:**
- Credential phishing to compromise legitimate accounts
- Domain spoofing with lookalike domains
- Thread hijacking in existing email conversations
- Targeting of finance, HR, or executive assistants
- Requests timed around travel or busy periods


---

## Data Breach

Unauthorized access to or exfiltration of sensitive data, potentially triggering notification requirements.

**Indicators:**
- Evidence of data exfiltration (network logs, file access)
- Unauthorized access to databases or file shares
- Personal data or trade secrets accessed
- Data appearing on dark web or paste sites
- Anomalous data transfers to external destinations

**Reporting considerations:**
- Quantify records and individuals affected
- Classify data types exposed (PII, PHI, financial)
- Determine geographic scope for notification requirements
- Document evidence of actual exfiltration vs. access only
- Prepare for notification timeline requirements

**Common patterns:**
- SQL injection or application vulnerabilities
- Compromised credentials with data access
- Insider access abuse
- Cloud storage misconfigurations
- Third-party/vendor compromise


---

## Insider Threat

Malicious or negligent actions by employees, contractors, or partners with authorized access.

**Indicators:**
- Unusual data access patterns by authorized users
- Large file downloads or transfers before departure
- Access outside normal working hours or locations
- Circumvention of security controls
- Policy violations discovered through monitoring

**Reporting considerations:**
- Document the insider's role and access level
- Distinguish between malicious and negligent actions
- Preserve evidence for potential legal action
- Coordinate with HR and legal before confrontation
- Consider privacy implications of monitoring evidence

**Common patterns:**
- Departing employees taking data
- Privileged access abuse for personal gain
- Accidental exposure through misconfiguration
- Credential sharing leading to unauthorized access
- Coercion or recruitment by external actors


---

## Supply Chain Compromise

Attack through a trusted third party, vendor, or software component.

**Indicators:**
- Malicious update from trusted software vendor
- Compromised vendor credentials used for access
- Exploitation of vendor-managed systems
- Third-party breach affecting shared data
- Malicious code in dependencies or libraries

**Reporting considerations:**
- Identify the compromised vendor or component
- Determine scope of vendor access to your environment
- Document timeline of malicious updates or access
- Coordinate disclosure with affected vendor
- Assess impact on other customers if relevant

**Common patterns:**
- Software update mechanism compromise
- MSP/MSSP credential theft for customer access
- Open source dependency poisoning
- Hardware implants or firmware modifications
- Trusted connection/VPN abuse


