# Field Guidance for IR Report Completeness

Use this guidance to check if an IR report covers all required fields.

## Required Fields

- timeline
- affected_systems
- root_cause
- actions_taken
- business_impact
- what_went_well
- third_party_involvement
- data_exposure

---

## Incident Timeline

**Purpose:** Establishes when events occurred, enabling readers to understand the sequence and duration of the incident. Critical for regulatory reporting deadlines and post-incident analysis.

**What indicates this field is covered:**
- Specific dates and times (not vague references like "recently")
- Duration information (how long the attack was active)
- Sequence of events from initial access to containment
- When alerts fired or anomalies were first noticed
- Gap between actual compromise and detection

**Common problems:**
- Vague timeframes ("last week", "recently") instead of specific dates
- Missing the gap between initial compromise and detection
- Timeline stops at detection without covering response milestones
- No distinction between when incident occurred vs. when discovered

**Questions to ask if missing:**
- When was the incident first detected?
- When did the incident actually begin (if different from detection)?
- What is the timeline of key response milestones?
- How long was the attacker in the environment before detection?

**Good example:**
> The attacker gained initial access on January 15, 2025 at 14:32 UTC via a phishing email. Lateral movement to the file server occurred on January 17. The security team detected the activity on January 19 at 09:15 when EDR alerts fired. Containment was completed by January 19 at 18:00.

**Poor example:**
> The incident happened sometime last week. We found out about it recently.


---

## Affected Systems

**Purpose:** Documents what was compromised, helping stakeholders understand the scope and prioritize remediation. Essential for insurance claims and regulatory filings.

**What indicates this field is covered:**
- Specific system names, IP addresses, or hostnames
- Count of affected servers, workstations, or accounts
- Types of systems (production vs. development, on-prem vs. cloud)
- Business functions impacted by affected systems

**Common problems:**
- Vague descriptions ("some servers") without specifics
- Missing the scope (how many systems total)
- No distinction between directly compromised vs. potentially exposed

**Questions to ask if missing:**
- Which specific systems were confirmed compromised?
- How many systems were affected (total count)?
- Were any critical business systems impacted?
- What data did these systems contain or process?

**Good example:**
> Three systems were compromised: the file server (FS01), a domain controller (DC02), and the HR manager's workstation (WS-HR-001). An additional 12 workstations showed signs of reconnaissance activity but no confirmed compromise.

**Poor example:**
> Several servers and some workstations were affected.


---

## Root Cause

**Purpose:** Explains how the attacker succeeded. Critical for preventing recurrence and demonstrating due diligence to regulators and leadership.

**What indicates this field is covered:**
- Initial access vector (phishing, vulnerability, credential theft)
- Specific vulnerability exploited (CVE number if applicable)
- Security control that failed or was missing
- Human factor if applicable (who clicked, what was misconfigured)

**Common problems:**
- Stopping at "phishing" without explaining why it succeeded
- Missing the underlying security gap that enabled the attack
- Confusing symptoms with root cause

**Questions to ask if missing:**
- How did the attacker gain initial access?
- What security control failed or was missing?
- Was a specific vulnerability exploited?
- Why did existing defenses not prevent or detect this sooner?

**Good example:**
> Initial access was via a phishing email containing a malicious attachment. The user (Accounting Dept.) opened the attachment, which exploited CVE-2024-1234 in the document viewer. EDR was not deployed on this workstation due to a gap in the deployment process for new hires.

**Poor example:**
> The attacker used phishing to get in.


---

## Actions Taken

**Purpose:** Documents the response, showing stakeholders that appropriate steps were taken and creating a record for future incidents.

**What indicates this field is covered:**
- Containment actions (isolation, credential resets, blocks)
- Eradication steps (malware removal, system rebuilds)
- Recovery activities (restoration, validation)
- Communication actions (notifications, briefings)

**Common problems:**
- Too high-level ("we contained the incident")
- Missing who took each action
- No indication of timing or sequence

**Questions to ask if missing:**
- What containment actions were taken and when?
- How was the malware/attacker removed?
- What recovery steps were performed?
- Who was involved in the response?

**Good example:**
> Upon detection, the SOC immediately isolated the three affected systems from the network (January 19, 18:30). IT reset passwords for all administrative accounts within 2 hours. The IR team rebuilt FS01 from clean backups on January 21 after forensic imaging.

**Poor example:**
> We contained and remediated the incident.


---

## Business Impact

**Purpose:** Quantifies the harm to the organization, essential for leadership decisions, insurance claims, and demonstrating severity.

**What indicates this field is covered:**
- Financial costs (response, recovery, lost revenue)
- Operational disruption (downtime, delayed projects)
- Reputational impact (customer notifications, media coverage)
- Regulatory consequences (fines, required actions)

**Common problems:**
- Missing quantification ("significant impact")
- Only covering direct costs, missing indirect impact
- No business context for technical impacts

**Questions to ask if missing:**
- What was the estimated financial impact?
- How long were business operations disrupted?
- Were any customers or partners affected?
- What regulatory or legal consequences are expected?

**Good example:**
> The incident resulted in 3 days of degraded file server access, affecting approximately 200 employees. Estimated costs: $50,000 in incident response services, $30,000 in lost productivity, and potential regulatory fines pending GDPR notification outcome.

**Poor example:**
> The incident had a significant business impact.


---

## What Went Well

**Purpose:** Identifies effective response elements to preserve and build upon. Provides balance and recognizes team efforts.

**What indicates this field is covered:**
- Successful detection mechanisms
- Effective response actions
- Tools or processes that worked as intended
- Team collaboration or communication successes

**Common problems:**
- Omitting this section entirely (all negative)
- Vague praise without specifics
- Confusing "got lucky" with "worked well"

**Questions to ask if missing:**
- What detection mechanisms helped identify this incident?
- Which response actions were particularly effective?
- What tools or processes worked as intended?
- How did the team collaborate effectively?

**Good example:**
> The EDR solution detected the lateral movement within 18 hours of initial compromise. The pre-established communication channel with the CISO enabled rapid executive notification. Clean backups were available and tested, enabling recovery without ransom payment.

**Poor example:**
> The team did a good job responding.


---

## Third-Party Involvement

**Purpose:** Documents external parties for coordination, cost tracking, and demonstrating appropriate escalation.

**What indicates this field is covered:**
- IR consultants or forensic firms engaged
- Law enforcement notifications
- Legal counsel consultation
- Insurance carrier notification
- Vendor involvement (affected or supporting)

**Common problems:**
- Missing legal counsel involvement
- Not documenting law enforcement decisions
- Forgetting insurance notification requirements

**Questions to ask if missing:**
- Were any external IR or forensic firms engaged?
- Was law enforcement notified? If not, why?
- When was legal counsel consulted?
- Was the cyber insurance carrier notified?

**Good example:**
> External parties engaged: CrowdStrike for forensic analysis (January 20), outside counsel (Baker McKenzie) for breach notification guidance, FBI field office notified (January 22), cyber insurance carrier (AIG) notified within 24-hour policy requirement.

**Poor example:**
> We worked with some external parties.


---

## Data Exposure

**Purpose:** Documents what data was at risk, critical for notification decisions, regulatory compliance, and risk assessment.

**What indicates this field is covered:**
- Types of data accessed or exfiltrated
- Volume of records affected
- Sensitivity classification
- Data subjects affected (employees, customers, partners)

**Common problems:**
- Not distinguishing accessed vs. exfiltrated
- Missing data subject counts
- Vague data descriptions ("sensitive data")

**Questions to ask if missing:**
- What types of data were accessed or exfiltrated?
- How many records or individuals were affected?
- Was personal data (PII) involved?
- Is there evidence of actual exfiltration vs. just access?

**Good example:**
> The attacker accessed a file share containing HR records for 1,247 current and former employees, including names, SSNs, and salary information. Network logs confirm 2.3 GB of data was exfiltrated to an external IP. No customer data was on the affected systems.

**Poor example:**
> Some sensitive data may have been exposed.


---

## Confidence Level

**Purpose:** Communicates certainty of findings, enabling appropriate decision-making and setting expectations for potential revisions.

**What indicates this field is covered:**
- Explicit confidence statements (high/moderate/low)
- Basis for conclusions (evidence cited)
- Acknowledged gaps or uncertainties
- Preliminary vs. final designation

**Common problems:**
- Presenting uncertain findings as definitive
- Not explaining basis for conclusions
- Missing acknowledgment of investigation gaps

**Questions to ask if missing:**
- How confident are you in the root cause determination?
- What evidence supports the key conclusions?
- Are there gaps in the investigation?
- Is this a preliminary or final assessment?

**Good example:**
> Confidence level: Moderate. The root cause assessment is based on EDR telemetry and email gateway logs. Full forensic analysis of the initial workstation is pending. The exfiltration volume is confirmed via netflow data, but content analysis is ongoing.

**Poor example:**
> (No confidence level stated; findings presented as certain)


